/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Mshg terrain; // terrain mesh
Flt  hour   ; // current hour
/******************************************************************************/
void InitPre()
{
   App.name="Nature";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).ambPower(0.2).hpRt(true).shdSoft(1).shdMapSize(1024);
}
/******************************************************************************/
Bool Init()
{
   Cam.dist=6;
   Cam.at.set(0,2,0);
   Sky.set();                         // sky
   Sun.set(*Gfxs("gfx/sky/sun.gfx")); // sun
   Sun.rays.mode=SUN_RAYS_HIGH;

   // load terrain mesh
   terrain.load("obj/terrain/0.mshg");

   // set initial hour
   hour=5;

   // load clouds
   Clouds.layered.set(3,Gfxs("Clouds/Layers/0.gfx"));
   REPAO(Clouds.layered.layer).velocity*=4;

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,100,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT)); // move camera on right mouse button

   // update hour
   hour+=Tm.d*2;

   // set sun position
   SinCos(Sun.pos.y,Sun.pos.x,hour/24*PI2-PI_2); Sun.pos.z=0;
   Sun.pos*=Matrix3().setRotateY(PI-PI_4);

   // tweak the sun to rise earlier, and set later
   Sun.pos.y+=0.5;
   Sun.pos.normalize();

   // set sun power and color
   Sun.power=Sat(Cbrt(Sun.pos.y));

   // set sky color
   Vec   night_color(0.02,0.04,0.10),
       horizon_color(0.35,0.45,0.64),
           sky_color(0.30,0.38,0.54);
   Sky.set(Lerp(night_color,horizon_color,Sun.power),sky_color*Sun.power);

   // update clouds
   Clouds.volumetric.update(Vec2(60));
   Clouds.volumetric.dark_color  =0.38*Sun.power;
   Clouds.volumetric.bright_color=0.70*Sun.power;

   Clouds.layered.update();
   REP(Clouds.layered.layers())Clouds.layered.layer[i].color=ColorBrightness(Sun.power);

   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SHD_MAP:
      case RM_SOLID  :
         terrain.draw(MatrixIdentity); // render terrain
      break;
   }
}
void Draw()
{
   Renderer(Render);
   D.text(0,0.9,S+"Hour "+(Trunc(hour)%24));
}
/******************************************************************************/
